/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  EXGSCAN.C
**************************************************************************/

#include <nunicode.h>
#include <stdio.h>

void main(void)
{
   pCONVERT pconv;
   nint     icode;
   nint     byteScanAction, uniScanAction;

   /* Load a byte/uni converter for the current code page.
      Error checking not shown. */
   icode = NWUXLoadByteUnicodeConverter(0, &pconv);

   icode = NWUXGetScanAction(pconv, &byteScanAction, &uniScanAction);
   if (icode)
      printf("NWUXGetScanAction returned error 0x%04X\n",icode);
   else
   {
      printf("Byte scan action    "
             "(i.e. byte-to-uni \"[2620]\" --> 0x2620 ):  ");
      switch (byteScanAction)
      {
         case NWU_ENABLED:   printf("Enabled\n");  break;
         case NWU_DISABLED:  printf("Disabled\n");  break;
      }

      printf("Unicode scan action "
             "(i.e. uni-to-byte   \"[81]\" --> 0x81 ):    ");
      switch (uniScanAction)
      {
         case NWU_ENABLED:   printf("Enabled\n");  break;
         case NWU_DISABLED:  printf("Disabled\n");  break;
      }

   }

   NWUXUnloadConverter(pconv);
}

/* Output from this routine (default behavior):
  Byte scan action    (i.e. byte-to-uni "[2620]" --> 0x2620 ):  Enabled
  Unicode scan action (i.e. uni-to-byte   "[81]" --> 0x81 ):    Disabled
*/

