/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  EXSSUBB.C
***************************************************************************

  Change the substitution byte to use in uni-to-byte conversions. 
  
**************************************************************************/

#include <nunicode.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>

void main(void)
{
   pCONVERT pconv;
   nint     icode;
   nuint    actualLen;
   nuint8   subByte = '?';     /* Change the substitution byte to '?' */
   unicode  uniIn[5] = { 'a', 'b', 'c', 0x2620, 0 };   /* Test string */
   nuint8   byteOut[80];

   /* Load a byte/uni converter for the current code page.
      Error checking not shown. */
   icode = NWUXLoadByteUnicodeConverter(0, &pconv);

   /* Set the action for unmappable unicodes to use a substitute byte.
      This is not the default for uni-to-byte conversions. */
   icode = NWUXSetNoMapAction(pconv, NWU_UNCHANGED_ACTION,
                              NWU_SUBSTITUTE);

   icode = NWUXSetSubByte(pconv, subByte);
   if (icode)
      printf("NWUXSetSubByte returned error 0x%04X\n",icode);

   icode = NWUXUnicodeToByte(pconv, byteOut, 80, uniIn, &actualLen);
   assert(icode == 0  &&  strcmp(byteOut,"abc?") == 0 && actualLen == 4);

   NWUXUnloadConverter(pconv);
} 


