/* ***************************************************************************

  $Archive: $
  $Revision: $
  $Modtime: $
 
 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.

 ****************************************************************************/

/**************************************************************************
   READINFO.C
***************************************************************************

  READINFO.C uses NWDSReadObjectInfo to to return non-attribute object 
  information about the specified Directory Services object.  This example 
  prompts the user for an object name then displays the object flags, 
  subordinate count, modification time and base class.  This example will 
  also prompt the user to authenticate to NDS, if necessary.

**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ntypes.h>
#include <nwnet.h>
#include <nwcalls.h>
#include <nwlocale.h>

/* Globals */

NWDSContextHandle   context;
nbool8              bbDoLogout;

/* Prototypes */

void Proc(void);
void InitDS(void);
void UninitDS(void);

/***************************************************************************
**   Main Program
*/
void main(void)
{
   InitDS();
   Proc();
   UninitDS();
}

/***************************************************************************
**   Prompt users for object name to display the object info.
*/
void Proc(void)
{
   NWDSCCODE       ccode;
   Object_Info_T   objectInfo;
   nstr8           strObjectName[MAX_DN_CHARS+1];
   nstr8           strObjectDName[MAX_DN_CHARS+1];

   printf("\nObject Name to read: ");
   gets(strObjectName);
   strcat(strObjectName,"\x0");

   ccode = NWDSReadObjectInfo(
            /* context handle (IN)      */ context, 
            /* object to read (IN)      */ strObjectName, 
            /* distinguished name (OUT) */ strObjectDName, 
            /* return buffer (OUT)      */ &objectInfo);
   if(ccode)
   {
      printf("NWDSReadObjectInfo returned %04X\n", ccode);
   }
   else
   {
      printf("Distiguished Name :%s\n\n", strObjectDName);
      printf("ObjectFlags       :%lu\n", objectInfo.objectFlags);
      printf("Subordinate Count :%lu\n", objectInfo.subordinateCount);
      printf("Modification Time :%s", ctime(&objectInfo.modificationTime));
      printf("Base Class        :%s\n", objectInfo.baseClass);
   }
}

/***************************************************************************
**   Establish context, standard initializations for DS calls
*/
void InitDS(void)
{
   NWDSCCODE   ccode;
   LCONV       lconvInfo;
   nstr8       strUserName[NW_MAX_USER_NAME_LEN];
   nstr8       strUserPassword[50];

   /* Initialize libraries */
   ccode=NWCallsInit(NULL,NULL);
   if(ccode)       
   {
      printf("\nNWCallsInit returned %04X", ccode);
      exit(1);
   }

   NWLlocaleconv(&lconvInfo);

   ccode = NWInitUnicodeTables(lconvInfo.country_id, lconvInfo.code_page);
   if(ccode)
   {
      printf("\nNWInitUnicodeTables returned %04X", ccode);
      exit(1);
   }

   ccode = NWDSCreateContextHandle(&context);
   if(ccode)
   {
      printf("\nNWDSCreateContextHandle returned %04X", ccode);
      NWFreeUnicodeTables();
      exit(1);
   }

   /*  Must authenticate if not already authenticated to NDS
       (which will always be the case if this example is 
       compiled and run as an NLM).  */
   if(!NWIsDSAuthenticated())
   {
      printf("\nMust authenticate to NDS");
      printf("\nEnter User Name: ");
      gets(strUserName);
      printf("Enter User Password: ");
      gets(strUserPassword);

      ccode = NWDSLogin(context, 0, strUserName, strUserPassword, 0);
      if(ccode)
      {
         printf("\nNWDSLogin returned %X", ccode);
         NWDSFreeContext(context);
         NWFreeUnicodeTables();
         exit(1);
      }

      /* If example logs in, it will also log out */
      bbDoLogout = N_TRUE;
   }
}

/***************************************************************************
**   Release context and clean up.
*/
void UninitDS(void)
{
   NWDSCCODE   ccode;

   if(bbDoLogout)
   {
      ccode = NWDSLogout(context);
      if(ccode)
      {
         printf("\nNWDSLogout returned %04X", ccode);
      }
   }

   ccode=NWDSFreeContext(context);
   if(ccode)
   {
      printf("\nNWDSFreeContext returned %04X", ccode);
   }

   ccode=NWFreeUnicodeTables();
   if(ccode)
   {
      printf("\nNWFreeUnicodeTables returned %04X", ccode);
   }
} 
