/*************************************************************************

  Copyright (c) 1995, 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
   READDB.C
***************************************************************************

  READDB reads the NAMESDB.DBT file, displays the records to the screen 
  and allows the user to alter the records. The resulting database file
  can then be used to sync data to a Directory Services database.

**************************************************************************/

#include <string.h>
#include <stdio.h>

/* Globals   */

FILE *stream;

typedef struct
{
   char   fdn[256];
   char   FullName[100];
   char   CName[40];
   char   SurName[40];
   char   Telephone[20];
}dbRecord;


/* Prototypes */

void ReadDB(dbRecord *nameRecord);
void AlterRecord(dbRecord *nameRecord, int recordNumber);


int main(void)
{
   dbRecord   namesDB;
   char       ch;
   int        recordCount = 0, i;

   if((stream = fopen("NAMESDB.DBT", "r+t")) == NULL)
   {
      fprintf(stderr, "Cannot open NAMESDB.DBT file\n");
      return(1);
   }

   while(!feof(stream))
   {
      ReadDB(&namesDB);
      recordCount += 1;
   }

   --recordCount;

   fseek(stream, 0L, SEEK_SET);

   for (i = 0; i < recordCount; ++i)
   {
      ReadDB(&namesDB);
      printf("\nObject Name: %s", namesDB.fdn);
      printf("\nFull Name  : %s", namesDB.FullName);
      printf("\nCommon Name: %s", namesDB.CName);
      printf("\nSurname    : %s", namesDB.SurName);
      printf("\nTelephone #: %s\n", namesDB.Telephone);
      printf("\nDo you wish to change any fields in this record (Y/N)?");
      ch = getch();
      if ((ch == 'Y') || (ch == 'y'))
         AlterRecord(&namesDB, i);
   }

   fclose(stream);
   return(0);
}

void ReadDB(dbRecord *nameRecord)
{
   fread(nameRecord, sizeof(dbRecord), 1, stream);
}

void AlterRecord(dbRecord *nameRecord, int recordNumber)
{
   int    done = 0;
   char   ch;
   long   curpos;

   while(!done)
   {
      printf("\nObject Name: %s", nameRecord->fdn);
      printf("\nField 1: Full Name  : %s", nameRecord->FullName);
      printf("\nField 2: Common Name: %s", nameRecord->CName);
      printf("\nField 3: Surname    : %s", nameRecord->SurName);
      printf("\nField 4: Telephone #: %s\n", nameRecord->Telephone);
      printf("\nPlease enter the number of the field you wish to change. (E)xit or (S)ave: ");
      ch = getch();

      switch (ch)
      {
         case '1':
            printf("\nFull Name : ");
            memset(nameRecord->FullName, 0, sizeof(nameRecord->FullName));
            gets(nameRecord->FullName);
            if (strlen(nameRecord->FullName) > 100)
               printf("\nThe string is too long! Please reenter.");
            break;

         case '2':
            printf("\nCommon Name : ");
            memset(nameRecord->CName, 0, sizeof(nameRecord->CName));
            gets(nameRecord->CName);
            if (strlen(nameRecord->CName) > 40)
               printf("\nThe string is too long! Please reenter.");
            break;

         case '3':
            printf("\nSurname : ");
            memset(nameRecord->SurName, 0, sizeof(nameRecord->SurName));
            gets(nameRecord->SurName);
            if (strlen(nameRecord->SurName) > 40)
               printf("\nThe string is too long! Please reenter.");
            break;

         case '4':
            printf("\nTelephone : ");
            memset(nameRecord->Telephone, 0, sizeof(nameRecord->Telephone));
            gets(nameRecord->Telephone);
            if (strlen(nameRecord->Telephone) > 20)
               printf("\nThe string is too long! Please reenter.");
            break;

         case 'e':
         case 'E':
            done = 1;
            break;

         case 's':
         case 'S':
            curpos = ftell(stream);
            fseek(stream, (recordNumber * sizeof(dbRecord)), SEEK_SET);
            fwrite(nameRecord, sizeof(dbRecord), 1, stream);
            fseek(stream, curpos, SEEK_SET);
            done = 1;
            break;

      }
   }  
} 
