/************************************************************************** 
  ADDLANG.C 
*************************************************************************** 
 
  This example demonstrates how to add a language to the OS supported 
  language list. 
 
**************************************************************************/ 
 
#include <stdio.h>  
#include <stdlib.h>  
#include <string.h> 
#include <nwthread.h>  
#include <nwadv.h> 
  
#define MAX_LANGUAGE_ID      999  
#define MIN_NON_NETWARE_ID   100  
#define MAX_LANGUAGE_NAME    255  
 
int main(void)  
{  
   int    ID = MIN_NON_NETWARE_ID;  
   LONG   len;  
   int    ccode = TRUE;  
   char   **messageTable;  
   LONG   messageCount = 0;  
   LONG   languageID;  
   BYTE   languageName[MAX_LANGUAGE_NAME];  
   BYTE   name[MAX_LANGUAGE_NAME];  
 
   /* Multi-Language enabled NLM applications can load tables of  
      messages for different languages by using this API. Default  
      Language tables can be bound to NLM applications with the  
      messages option in NLMLINK or NLMLINKP.  */  
 
   LoadLanguageMessageTable(&messageTable,  
                            &messageCount,  
                            &languageID);  
 
   /* NLMs can then access messages through the table like this...*/  
 
   if(messageCount)  
      printf("The first message in our table is %s.\n", messageTable[1]);  
 
   languageID = (LONG)GetCurrentOSLanguageID();  
   if(!ReturnLanguageName((int)languageID, languageName))  
   {  
      printf("The current language on this server is %i : %s\n",  
             languageID, languageName);  
   }  
 
   /*...find the next available ID number...*/  
   while(ccode && ID < MAX_LANGUAGE_ID)  
   {  
      ccode = AddLanguage(ID, (BYTE *)"TEST LANGUAGE", TRUE);  
      if (ccode) ID++;  
   }  
   if (!ccode)  
   {  
      printf("Test language %i added to OS language list.\n", ID);  
      strcpy((char *)name, "PIG LATIN 0");  
 
      /*...find a unique name for this language...*/  
      ccode = TRUE;  
      while(ccode)  
      {  
         ccode = RenameLanguage(ID, name, TRUE);  
         if (ccode)  
         {  
            len = strlen((char *)name);  
            name[len - 1]++;  
         }  
      }  
      if(!ccode)  
      {  
         ReturnLanguageName(ID, languageName);  
         printf("The name of language %i is %s.\n", ID, languageName);  
         SetCurrentOSLanguageID((LONG)ID);  
         languageID = (LONG)GetCurrentOSLanguageID();  
 
         if(!ReturnLanguageName((int)languageID, languageName))  
            printf("The current language on this server is %i : %s\n",  
                   languageID, languageName);  
      }  
      else  
         printf("Unable to rename test language.\n");  
   }  
   else  
      printf("Unable to add test language to OS language list.\n");  
 
   return(0); 
}   
