/*************************************************************************

  Copyright (c) 1999 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/*************************************************************************
   GETCAPFL.C
**************************************************************************

  GETCAPFL demonstrates how to get and set the print flags for an lpt device
  redirection.

  Usage:  GETCAPFL <mode> <flag> <port>
  
           <mode>  CLEAR, SET, or TOGGLE
           <flag>  RELEASE, SUPPRESS, NOTIFY, TAB, BANNER
           <port>  LPT?  1 for LPT1, 2 for LPT2, etc...

*************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <nwcalls.h>
#include <nwndscon.h>
#include <nwclxcon.h>

void main (int argc, char *argv[])
{
   NWCCODE               ccode;
   NWCAPTURE_FLAGSRW    flags1;
   NWCAPTURE_FLAGSRO    flags2;
   NWCONN_HANDLE         connHandle;
   nuint32              connRef;

   int                  lpt;


   /* Check command-line arguments */
   if (argc != 4)
   {
      printf ("Usage:  %s <mode> <flag> <port>\n\n", strupr(argv[0]));
      printf ("<mode>  CLEAR, SET, or TOGGLE\n");
      printf ("<flag>  RELEASE, SUPPRESS, NOTIFY, TAB, BANNER\n");
      printf ("<port>  LPT?  1 for LPT1, 2 for LPT2, etc...\n");
      return;
   }

   /* Library initialization */
   ccode = NWCallsInit(NULL,NULL);
   if(ccode)
   {
      printf("NWCallsInit failed with error code=0x%04x\n", ccode);
      return;
   }

   /* Get a connection handle */
   ccode = NWGetNearestDSConnRef(&connRef);
   if(ccode)
   {
      printf("NWGetNearestDSConnRef failed with error code=0x%04x\n", ccode);
      return;
   }
   ccode = NWCCOpenConnByRef(connRef, NWCC_OPEN_UNLICENSED, 0, &connHandle);
   if(ccode)
   {
      printf("NWCCOpenConnByRef failed with error code=0x%04x\n", ccode);
      return;
   }

   /* Get the current capture flags */
   lpt = atoi (argv[3]);
   ccode = NWGetCaptureFlags ((nuint8)lpt, &flags1, &flags2);
   if (ccode)
   {
      printf("NWGetCaptureFlags failed with error code=0x%04x\n", ccode);
   }
   else
   {
      printf ("Queue name is %s\n", flags2.queueName);
   }

   /* 
    *  Modify the print flags from the command-line arguments  and call
    *  NWSetCaptureFlags()
    */
   if (0 == ccode)
   {
   if(stricmp (argv[1], "CLEAR") == 0)
   {
      if (stricmp (argv[2], "RELEASE") == 0)
      {
         flags1.printFlags &= 0xFFFB;
      }
      if (stricmp (argv[2], "SUPPRESS") == 0)
      {
         flags1.printFlags &= 0xFFF7;
      }
      if (stricmp (argv[2], "NOTIFY") == 0)
      {
         flags1.printFlags &= 0xFFEF;
      }
      if (stricmp (argv[2], "TAB") == 0)
      {
         flags1.printFlags &= 0xFFBF;
      }
      if (stricmp (argv[2], "BANNER") == 0)
      {
         flags1.printFlags &= 0xFF7F;
      }
   }
   else if (stricmp (argv[1], "SET") == 0)
   {
      if (stricmp (argv[2], "RELEASE") == 0)
      {
         flags1.printFlags |= 0x0004;
      }
      if (stricmp (argv[2], "SUPPRESS") == 0)
      {
         flags1.printFlags |= 0x0008;
      }
      if (stricmp (argv[2], "NOTIFY") == 0)
      {
         flags1.printFlags |= 0x0010;
      }
      if (stricmp (argv[2], "TAB") == 0)
      {
         flags1.printFlags |= 0x0040;
      }
      if (stricmp (argv[2], "BANNER") == 0)
      {
         flags1.printFlags |= 0x0080;
      }
   }
   else
   {
         /* TOGGLE */
      if (stricmp (argv[2], "RELEASE") == 0)
      {
         flags1.printFlags ^= 0x0004;
      }
      if (stricmp (argv[2], "SUPPRESS") == 0)
      {
         flags1.printFlags ^= 0x0008;
      }
      if (stricmp (argv[2], "NOTIFY") == 0)
      {
         flags1.printFlags ^= 0x0010;
      }
      if (stricmp (argv[2], "TAB") == 0)
      {
         flags1.printFlags ^= 0x0040;
      }
      if (stricmp (argv[2], "BANNER") == 0)
      {
         flags1.printFlags ^= 0x0080;
      }
   }

      ccode = NWSetCaptureFlags (connHandle, (nuint8)lpt, &flags1);
   if(ccode)
   {
         printf("NWSetCaptureFlags failed with error code=0x%04x\n", ccode);
      }
      else
      {
         printf("Capture Flags are set.\n");
      }
   }

   /* Clean-up */
   ccode = NWCCCloseConn(connHandle);
   if (ccode) 
   {
      printf("NWCCCloseConn failed with error code=0x%04x\n", ccode);
   }
}
